//%attributes = {}
// Method: _sel_ QUERY_LOCK_SET 
// 22.08.12, 21:44:54 / MG_PM
// © Copyright Manage Applications
// Purpose: 
// 
//The SET QUERY AND LOCK command can be used to request the automatic locking of records 
//found by all queries that follow the calling of this command in the current transaction. 
//This means that the records cannot be modified by a process other than the current process 
//between a query and the handling of results.

//When a SET QUERY AND LOCK(True) statement has been executed, the query commands (for example QUERY) 
//adopt a specific functioning if a record that is already locked is found
// The query is stopped and the system variable OK is set to 0,
// The current selection is cleared,
// The LockedSet system set contains the locked record that caused the query to be 

// http://doc.4d.com/4D-Language-Reference-11.6/Queries/SET-QUERY-AND-LOCK.301-205799.en.html
// ------------------------------------------------------------
If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStart; Current method name:C684)
End if 

C_LONGINT:C283($1; $_sel_lLockRecordsInQuery)
$_sel_lLockRecordsInQuery:=$1

If (False:C215)
	// replace calls to these (and delete) _sel_ WAIT:
	_sel_ WAIT
End if 

Case of 
	: (_rd_ RemoteIs(0)=kTrue)  // _rem_sel_
		TRACE:C157  // test this and remove TRACE
		_rem_ CALL_SET("_sel_QUERY_LOCK_SET")
		_rem_ PARAM_LONG_SET($_sel_lLockRecordsInQuery)
		_rem_ CALL(Current method name:C684)
		
	: (_rd_ SqlIs(0)=kTrue)
		_err MESSAGE_NOT_DONE(Current method name:C684+" SQL"; kFalse)
		
	: (_rd_ LocalIs(0)=kTrue)
		
		Case of 
			: ($_sel_lLockRecordsInQuery=kTrue)
				OK:=1  // we must set this here
				SET QUERY AND LOCK:C661(True:C214)
			: ($_sel_lLockRecordsInQuery=kFalse)
				SET QUERY AND LOCK:C661(False:C215)
			Else 
				_err MESSAGE_PARAMETER("$1"; Current method name:C684; kFalse)
		End case 
		
	Else 
		_err MESSAGE("Unknown database"; Current method name:C684; kFalse)
End case 


If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStop; Current method name:C684)
End if 
